using System;
using System.IO;
using Android.App;
using Android.Graphics;

using Java.Nio;

namespace POIApp
{
	public class POIData
	{
		public static readonly IPOIDataService Service =
			new POIJsonService(
					System.IO.Path.Combine(
					Android.OS.Environment.ExternalStorageDirectory.Path,
					"POIApp"));

		public static Bitmap GetImageFile(int poiId)
		{
			string filename = Service.GetImageFilename (poiId);
			if (File.Exists (filename)) {
				Java.IO.File imageFile = new Java.IO.File (filename);
				return BitmapFactory.DecodeFile (imageFile.Path);
			}
			else
				return null;
		}
	}
}