using System;
using Android.App;
using Android.Content;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.OS;

namespace POIApp
{
	[Activity (Label = "POIs", MainLauncher = true)]
	public class POIListActivity : Activity
	{
		ListView _poiListView;
		POIListViewAdapter _adapter;

		protected override void OnCreate (Bundle bundle)
		{
			base.OnCreate (bundle);

			SetContentView (Resource.Layout.POIList);

			_poiListView = FindViewById<ListView> (Resource.Id.poiListView);
			_adapter = new POIListViewAdapter (this);
			_poiListView.Adapter = _adapter;
			_poiListView.ItemClick += POIClicked;
		}

		public override bool OnCreateOptionsMenu(IMenu menu)
		{
			MenuInflater.Inflate(Resource.Menu.POIListViewMenu, menu);
			return base.OnCreateOptionsMenu(menu);
		}

		public override bool OnOptionsItemSelected (IMenuItem item)
		{
			switch (item.ItemId)
			{
			case Resource.Id.actionNew: 
					// place holder for creating new poi
					return true;

				case Resource.Id.actionRefresh: 
					POIData.Service.RefreshCache ();
					_adapter.NotifyDataSetChanged ();
					return true;

				default :
					return base.OnOptionsItemSelected(item);
			}
		}

		protected void POIClicked(object sender, ListView.ItemClickEventArgs e)
		{
			PointOfInterest poi = POIData.Service.GetPOI ((int)e.Id);
			Console.WriteLine ("POIClicked: Name is {0}", poi.Name);
		}
	}
}


