using System;
using Android.App;
using Android.Content;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.OS;

namespace POIApp
{
	[Activity (Label = "POIs", MainLauncher = true)]
	public class POIListActivity : Activity
	{
		ListView _poiListView;
		POIListViewAdapter _adapter;

		protected override void OnCreate (Bundle bundle)
		{
			base.OnCreate (bundle);

			SetContentView (Resource.Layout.POIList);

			_poiListView = FindViewById<ListView> (Resource.Id.poiListView);
			_adapter = new POIListViewAdapter (this);
			_poiListView.Adapter = _adapter;
			_poiListView.ItemClick += POIClicked;
		}

		protected override void OnResume ()
		{
			base.OnResume ();

			_adapter.NotifyDataSetChanged ();
		}

		public override bool OnCreateOptionsMenu(IMenu menu)
		{
			MenuInflater.Inflate(Resource.Menu.POIListViewMenu, menu);
			return base.OnCreateOptionsMenu(menu);
		}

		public override bool OnOptionsItemSelected (IMenuItem item)
		{
			switch (item.ItemId)
			{
			case Resource.Id.actionNew:
					StartActivity (typeof(POIDetailActivity));
					return true;

				case Resource.Id.actionRefresh: 
					POIData.Service.RefreshCache ();
					_adapter.NotifyDataSetChanged ();
					return true;

				default :
					return base.OnOptionsItemSelected(item);
			}
		}

		protected void POIClicked(object sender, ListView.ItemClickEventArgs e)
		{
			// setup the intent to pass the POI id to the detail view
			Intent poiDetailIntent = new Intent (this, typeof(POIDetailActivity));
			poiDetailIntent.PutExtra ("poiId", (int) e.Id);
			StartActivity (poiDetailIntent);
		}
	}
}


